---
title: System environment variables · Cloudflare Workers docs
description: Local environment variables that can change Wrangler's behavior.
lastUpdated: 2025-09-30T11:23:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/wrangler/system-environment-variables/
  md: https://developers.cloudflare.com/workers/wrangler/system-environment-variables/index.md
---

System environment variables are local environment variables that can change Wrangler's behavior. There are three ways to set system environment variables:

1. Create an `.env` file in your project directory. Set the values of your environment variables in your [`.env`](https://developers.cloudflare.com/workers/wrangler/system-environment-variables/#example-env-file) file. This is the recommended way to set these variables, as it persists the values between Wrangler sessions.

2. Inline the values in your Wrangler command. For example, `WRANGLER_LOG="debug" npx wrangler deploy` will set the value of `WRANGLER_LOG` to `"debug"` for this execution of the command.

3. Set the values in your shell environment. For example, if you are using Z shell, adding `export CLOUDFLARE_API_TOKEN=...` to your `~/.zshrc` file will set this token as part of your shell configuration.

Note

To set different system environment variables for each environment, create files named `.env.<environment-name>`. When you use `wrangler <command> --env <environment-name>`, the corresponding environment-specific file will be loaded instead of the `.env` file, so the two files are not merged.

Note

During local development, the values in `.env` files are also loaded into the `env` object in your Worker, so you can access them in your Worker code.

For example, if you set `API_HOST="localhost:3000"` in your `.env` file, you can access it in your Worker like this:

```js
const apiHost = env.API_HOST;
```

See the [Environment variables and secrets](https://developers.cloudflare.com/workers/development-testing/environment-variables/) page for more information on how to use `.env` files in local development.

## Supported environment variables

Wrangler supports the following environment variables:

* `CLOUDFLARE_ACCOUNT_ID` string optional

  * The [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) for the Workers related account.

* `CLOUDFLARE_API_TOKEN` string optional

  * The [API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) for your Cloudflare account, can be used for authentication for situations like CI/CD, and other automation.

* `CLOUDFLARE_API_KEY` string optional

  * The API key for your Cloudflare account, usually used for older authentication method with `CLOUDFLARE_EMAIL=`.

* `CLOUDFLARE_EMAIL` string optional

  * The email address associated with your Cloudflare account, usually used for older authentication method with `CLOUDFLARE_API_KEY=`.

* `WRANGLER_SEND_METRICS` string optional

  * Options for this are `true` and `false`. Defaults to `true`. Controls whether Wrangler can send anonymous usage data to Cloudflare for this project. You can learn more about this in our [data policy](https://github.com/cloudflare/workers-sdk/tree/main/packages/wrangler/telemetry.md).

* `CLOUDFLARE_HYPERDRIVE_LOCAL_CONNECTION_STRING_<BINDING_NAME>`string optional

  * The [local connection string](https://developers.cloudflare.com/hyperdrive/configuration/local-development/) for your database to use in local development with [Hyperdrive](https://developers.cloudflare.com/hyperdrive/). For example, if the binding for your Hyperdrive is named `PROD_DB`, this would be `CLOUDFLARE_HYPERDRIVE_LOCAL_CONNECTION_STRING_PROD_DB="postgres://user:password@127.0.0.1:5432/testdb"`. Each Hyperdrive is uniquely distinguished by the binding name.

* `CLOUDFLARE_API_BASE_URL` string optional

  * The default value is `"https://api.cloudflare.com/client/v4"`.

* `WRANGLER_LOG` string optional

  * Options for Logging levels are `"none"`, `"error"`, `"warn"`, `"info"`, `"log"` and `"debug"`. Levels are case-insensitive and default to `"log"`. If an invalid level is specified, Wrangler will fallback to the default. Logs can include requests to Cloudflare's API, any usage data being collected, and more verbose error logs.

* `WRANGLER_LOG_PATH` string optional

  * A file or directory path where Wrangler will write debug logs. If the path ends in `.log`, Wrangler will consider this the path to a file where all logs will be written. Otherwise, Wrangler will treat the path as a directory where it will write one or more log files using a timestamp for the filenames.

* `FORCE_COLOR` string optional

  * By setting this to `0`, you can disable Wrangler's colorised output, which makes it easier to read with some terminal setups. For example, `FORCE_COLOR=0`.

- `WRANGLER_HTTPS_KEY_PATH` string optional

  * Path to a custom HTTPS certificate key when running `wrangler dev`, to be used with `WRANGLER_HTTPS_CERT_PATH`.

- `WRANGLER_HTTPS_CERT_PATH` string optional

  * Path to a custom HTTPS certificate when running `wrangler dev`, to be used with `WRANGLER_HTTPS_KEY_PATH`.

* `DOCKER_HOST` string optional
  * Used for local development of [Containers](https://developers.cloudflare.com/containers/local-dev). Wrangler will attempt to automatically find the correct socket to use to communicate with your container engine. If that does not work (usually surfacing as an `internal error` when attempting to connect to your Container), you can try setting the socket path using this environment variable.

- `WRANGLER_R2_SQL_AUTH_TOKEN` string optional
  * API token used for executing queries with [R2 SQL](https://developers.cloudflare.com/r2-sql).

## Example `.env` file

The following is an example `.env` file:

```bash
CLOUDFLARE_ACCOUNT_ID=<YOUR_ACCOUNT_ID_VALUE>
CLOUDFLARE_API_TOKEN=<YOUR_API_TOKEN_VALUE>
CLOUDFLARE_EMAIL=<YOUR_EMAIL>
WRANGLER_SEND_METRICS=true
CLOUDFLARE_API_BASE_URL=https://api.cloudflare.com/client/v4
WRANGLER_LOG=debug
WRANGLER_LOG_PATH=../Desktop/my-logs/my-log-file.log
WRANGLER_R2_SQL_AUTH_TOKEN=<YOUR_R2_API_TOKEN_VALUE>
```

## Deprecated global variables

The following variables are deprecated. Use the new variables listed above to prevent any issues or unwanted messaging.

* `CF_ACCOUNT_ID`
* `CF_API_TOKEN`
* `CF_API_KEY`
* `CF_EMAIL`
* `CF_API_BASE_URL`
